﻿/*	AVAILABLE DATA
	thisCommand_obj
		data						This command's data
		run()						This function
		nextEvent()			Function that triggers the next sibling command
		storeTimeout()	Function that stores this command's timeout ID   (used to stop the script)
			var waitId = setTimeout( parentScript.nextEvent, thisCommand_obj.data.value*1000 );
			thisCommand_obj.storeTimeout( waitId );
		moveTimeout
			addTimeout( ID )
			remove( ID )
			exists( ID )
			removeAll()
*/
define_moveWait = function(command_obj)
{
	command_obj.run = function( thisCommand_obj )
	{
		if(TRACE_SCRIPT)
			trace("moveWait");
		// run next command
		var runNextCommand = function(thisCommand_obj){
			thisCommand_obj.moveTimeout.remove();		// remove timeout from storage
			thisCommand_obj.nextEvent();
		}// runNExtCommand()
		
		// wait a moment
		var waitTime = thisCommand_obj.data.value*1000;		// convert seconds to milliseconds
		thisCommand_obj.timeout = setTimeout( runNextCommand, waitTime, thisCommand_obj );
		thisCommand_obj.moveTimeout.addTimeout( thisCommand_obj.timeout );		// store wait timeout
	}// run()
	
	
	
	command_obj.moveTimeout = moveTimeout;		// allow this command to store its timeouts
}// define_moveWait()